<?php

/**
 * Copyright 2014 Fabian Grutschus. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those
 * of the authors and should not be interpreted as representing official policies,
 * either expressed or implied, of the copyright holders.
 *
 * @author    Fabian Grutschus <f.grutschus@lubyte.de>
 * @copyright 2014 Fabian Grutschus. All rights reserved.
 * @license   BSD
 * @link      http://github.com/fabiang/xmpp
 */

namespace Fabiang\Xmpp;

use PHPUnit\Framework\TestCase;
use Fabiang\Xmpp\Connection\ConnectionInterface;
use Fabiang\Xmpp\Event\EventManagerInterface;
use Fabiang\Xmpp\Protocol\ImplementationInterface;
use Fabiang\Xmpp\EventListener\Logger;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2014-01-17 at 10:05:30.
 *
 * @coversDefaultClass Fabiang\Xmpp\Client
 */
class ClientTest extends TestCase
{
    /**
     * @var Client
     */
    protected $object;

    /**
     * @var \PHPUnit_Framework_MockObject_MockObject
     */
    protected $options;

    /**
     * @var \PHPUnit_Framework_MockObject_MockObject
     */
    protected $connection;

    /**
     * @var \PHPUnit_Framework_MockObject_MockObject
     */
    protected $eventManager;

    /**
     * @var \PHPUnit_Framework_MockObject_MockObject
     */
    protected $implementation;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     *
     * @return void
     */
    protected function setUp()
    {
        $this->options = $this->createMock(Options::class);

        $this->connection = $this->createMock(ConnectionInterface::class);

        $this->options->expects($this->any())
            ->method('getConnection')
            ->willReturn($this->connection);

        $this->eventManager = $this->createMock(EventManagerInterface::class);
        $this->implementation = $this->createMock(ImplementationInterface::class);

        $this->options->expects($this->any())
            ->method('getImplementation')
            ->willReturn($this->implementation);

        $this->object  = new Client($this->options, $this->eventManager);
    }

    /**
     * Test constructor.
     *
     * @covers ::__construct
     * @covers ::setupImplementation
     * @uses Fabiang\Xmpp\Client::getEventManager
     * @uses Fabiang\Xmpp\Client::setEventManager
     * @uses Fabiang\Xmpp\Client::getOptions
     */
    public function testConstructor()
    {
        $this->connection->expects($this->once())
            ->method('setEventManager')
            ->with($this->equalTo($this->eventManager));

        $this->connection->expects($this->once())
            ->method('setOptions')
            ->with($this->equalTo($this->options));

        $this->implementation->expects($this->once())
            ->method('registerListener')
            ->with($this->isInstanceOf(Logger::class));

        $this->implementation->expects($this->once())
            ->method('setEventManager')
            ->with($this->equalTo($this->eventManager));

        $this->implementation->expects($this->once())
            ->method('setOptions')
            ->with($this->equalTo($this->options));

        $this->implementation->expects($this->once())
            ->method('register');

        $object = new Client($this->options, $this->eventManager);
        $this->assertSame($this->eventManager, $object->getEventManager());
        $this->assertSame($this->options, $object->getOptions());
    }

    /**
     * @covers ::__construct
     * @covers ::getConnection
     * @uses Fabiang\Xmpp\Client::setupImplementation
     * @uses Fabiang\Xmpp\Client::getEventManager
     * @uses Fabiang\Xmpp\Stream\SocketClient::__construct
     * @uses Fabiang\Xmpp\Connection\AbstractConnection::setEventManager
     * @uses Fabiang\Xmpp\Connection\AbstractConnection::setOptions
     * @uses Fabiang\Xmpp\Connection\Socket::__construct
     * @uses Fabiang\Xmpp\Connection\Socket::factory
     * @uses Fabiang\Xmpp\Connection\Socket::setSocket
     * @uses Fabiang\Xmpp\Event\EventManager::__construct
     */
    public function testConstructorCreatingDefaults()
    {
        $options = $this->createMock(Options::class);

        $options->expects($this->any())
            ->method('getImplementation')
            ->willReturn($this->implementation);

        $object = new Client($options);
        $this->assertInstanceOf(EventManagerInterface::class, $object->getEventManager());
        $this->assertInstanceOf(ConnectionInterface::class, $object->getConnection());
    }

    /**
     * Test connection.
     *
     * @covers ::connect
     * @uses Fabiang\Xmpp\Client::__construct
     * @uses Fabiang\Xmpp\Client::setupImplementation
     */
    public function testConnect()
    {
        $this->connection->expects($this->once())
            ->method('connect');

        $this->object->connect();
    }

    /**
     * Test disconnecting.
     *
     * @covers ::disconnect
     * @uses Fabiang\Xmpp\Client::__construct
     * @uses Fabiang\Xmpp\Client::setUpImplementation
     */
    public function testDisconnect()
    {
        $this->connection->expects($this->once())
            ->method('disconnect');

        $this->object->disconnect();
    }

    /**
     * Test sending data.
     *
     * @covers ::send
     * @uses Fabiang\Xmpp\Client::__construct
     * @uses Fabiang\Xmpp\Client::setUpImplementation
     */
    public function testSend()
    {
        $this->connection->expects($this->once())
            ->method('send')
            ->with($this->equalTo('test'));

        $message = $this->createMock(Protocol\ProtocolImplementationInterface::class);
        $message->expects($this->once())
            ->method('toString')
            ->willReturn('test');

        $this->object->send($message);
    }

    /**
     * Test setting and getting event manager.
     *
     * @covers ::getEventManager
     * @covers ::setEventManager
     * @uses Fabiang\Xmpp\Client::__construct
     * @uses Fabiang\Xmpp\Client::setUpImplementation
     */
    public function testSetAndGetEventManager()
    {
        $eventManager = $this->createMock(EventManagerInterface::class);
        $this->assertSame($eventManager, $this->object->setEventManager($eventManager)->getEventManager());
    }

    /**
     * Test getting options object.
     *
     * @covers ::getOptions
     * @uses Fabiang\Xmpp\Client::__construct
     * @uses Fabiang\Xmpp\Client::setUpImplementation
     */
    public function testGetOptions()
    {
        $this->assertSame($this->options, $this->object->getOptions());
    }

    /**
     * Test setter Option Connection in Client constructor
     *
     * @covers ::__construct
     * @uses Fabiang\Xmpp\Client::__construct
     * @uses Fabiang\Xmpp\Client::getOptions
     * @uses Fabiang\Xmpp\Client::setUpImplementation
     * @uses Fabiang\Xmpp\Options::getConnection
     */
    public function testOptionsConnection()
    {
        $options = new Options();
        $client = $this->getMockBuilder(Client::class)
            ->setMethods(array('setupImplement'))
            ->setConstructorArgs([$options])
            ->getMock();

        $optionsAssert = $client->getOptions();
        $this->assertInstanceOf(ConnectionInterface::class, $optionsAssert->getConnection());
    }
}
